/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BitmapUtils {
    public static Bitmap thresholdBitmap(Bitmap img, boolean shake) {
        int height = img.getHeight();
        int width = img.getWidth();
        int[] pixels = BitmapUtils.thresholdBitmapPixels(img, shake);
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)img.getConfig());
        mBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    public static List<Bitmap> cutBitmapByHeight(Bitmap bitmap, int maxHeight) {
        ArrayList<Bitmap> list = new ArrayList<Bitmap>();
        if (bitmap == null || maxHeight < 1) {
            return list;
        }
        for (int startHeight = 0; startHeight < bitmap.getHeight(); startHeight += maxHeight) {
            int endHeight = startHeight + maxHeight;
            if (endHeight > bitmap.getHeight()) {
                endHeight = bitmap.getHeight();
            }
            Bitmap sub = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)startHeight, (int)bitmap.getWidth(), (int)(endHeight - startHeight));
            list.add(sub);
        }
        return list;
    }

    public static byte[] addBytes(byte[] data1, byte[] data2) {
        byte[] data3 = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, data3, 0, data1.length);
        System.arraycopy(data2, 0, data3, data1.length, data2.length);
        return data3;
    }

    public static Bitmap resizeImage(Bitmap bitmap, int w, int h) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    public static Bitmap resizeImageAndRotation(Bitmap bitmap, int w, int h) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        Matrix matrix = new Matrix();
        matrix.setScale(1.0f, -1.0f);
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    private static byte[] getBinaryzationBytes(Bitmap bitmap) {
        return BitmapUtils.getBinaryzationBytes(bitmap, 128, false);
    }

    private static byte[] getBinaryzationBytes(Bitmap bitmap, boolean reverse) {
        return BitmapUtils.getBinaryzationBytes(bitmap, 128, reverse);
    }

    private static byte[] getBinaryzationBytes(Bitmap bitmap, int threshold, boolean reverse) {
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] data = new byte[width * height];
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int color = pixels[i * width + j];
                int gray = (int)(0.299 * (double)((color & 0xFF0000) >> 16) + 0.587 * (double)((color & 0xFF00) >> 8) + 0.114 * (double)(color & 0xFF));
                byte y = (byte)(reverse ? 1 : 0);
                byte n = (byte)(!reverse ? 1 : 0);
                data[i * width + j] = gray < threshold ? y : n;
            }
        }
        return data;
    }

    public static byte[] getCompressedBinaryzationBytes(Bitmap bitmap) {
        return BitmapUtils.getCompressedBinaryzationBytes(bitmap, 128, false);
    }

    public static byte[] getCompressedBinaryzationBytes(Bitmap bitmap, boolean reverse) {
        return BitmapUtils.getCompressedBinaryzationBytes(bitmap, 128, reverse);
    }

    public static byte[] getCompressedBinaryzationBytes(Bitmap bitmap, int threshold, boolean reverse) {
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int lineBytes = (width - 1) / 8 + 1;
        byte[] data = new byte[lineBytes * height];
        byte[] imageBytes = BitmapUtils.getBinaryzationBytes(bitmap, threshold, reverse);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < lineBytes; ++j) {
                byte unit = 0;
                for (int k = 0; k < 8; ++k) {
                    if ((j << 3) + k >= width) continue;
                    byte pixel = imageBytes[i * width + (j << 3) + k];
                    unit = (byte)(unit | (pixel & 1) << 7 - k);
                }
                data[i * lineBytes + j] = unit;
            }
        }
        return data;
    }

    public static Bitmap threshold(Bitmap img, boolean shake) {
        int height = img.getHeight();
        int width = img.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)img.getConfig());
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(img, 0.0f, 0.0f, paint);
        img = bmpGrayscale;
        width = img.getWidth();
        height = img.getHeight();
        int[] pixels = new int[width * height];
        img.getPixels(pixels, 0, width, 0, 0, width, height);
        int[] gray = new int[height * width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int red;
                int grey = pixels[width * i + j];
                gray[width * i + j] = red = (grey & 0xFF0000) >> 16;
            }
        }
        int e = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int g = gray[width * i + j];
                if (g >= 128) {
                    pixels[width * i + j] = -1;
                    e = g - 255;
                } else {
                    pixels[width * i + j] = -16777216;
                    e = g - 0;
                }
                if (!shake) continue;
                if (j < width - 1 && i < height - 1) {
                    int n = width * i + j + 1;
                    gray[n] = gray[n] + 7 * e / 16;
                    int n2 = width * (i + 1) + j;
                    gray[n2] = gray[n2] + 5 * e / 16;
                    int n3 = width * (i + 1) + j + 1;
                    gray[n3] = gray[n3] + e / 16;
                    if (j <= 0) continue;
                    int n4 = width * (i + 1) + j - 1;
                    gray[n4] = gray[n4] + 3 * e / 16;
                    continue;
                }
                if (j == width - 1 && i < height - 1) {
                    int n = width * (i + 1) + j;
                    gray[n] = gray[n] + 5 * e / 16;
                    continue;
                }
                if (j >= width - 1 || i != height - 1) continue;
                int n = width * i + j + 1;
                gray[n] = gray[n] + 7 * e / 16;
            }
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)img.getConfig());
        mBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    public static Bitmap filter(Bitmap src) {
        int width = src.getWidth();
        int height = src.getHeight();
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        src.getPixels(inPixels, 0, width, 0, 0, width, height);
        int index = 0;
        double redSum = 0.0;
        double greenSum = 0.0;
        double blueSum = 0.0;
        double total = height * width;
        for (int row = 0; row < height; ++row) {
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (int col = 0; col < width; ++col) {
                index = row * width + col;
                ta = inPixels[index] >> 24 & 0xFF;
                tr = inPixels[index] >> 16 & 0xFF;
                tg = inPixels[index] >> 8 & 0xFF;
                tb = inPixels[index] & 0xFF;
                redSum += (double)tr;
                greenSum += (double)tg;
                blueSum += (double)tb;
            }
        }
        int means = (int)(redSum / total);
        System.out.println(" threshold average value = " + means);
        for (int row = 0; row < height; ++row) {
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (int col = 0; col < width; ++col) {
                index = row * width + col;
                ta = inPixels[index] >> 24 & 0xFF;
                tr = inPixels[index] >> 16 & 0xFF;
                tg = inPixels[index] >> 8 & 0xFF;
                tb = inPixels[index] & 0xFF;
                if (tr >= means) {
                    tb = 255;
                    tg = 255;
                    tr = 255;
                } else {
                    tb = 0;
                    tg = 0;
                    tr = 0;
                }
                outPixels[index] = ta << 24 | tr << 16 | tg << 8 | tb;
            }
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)src.getConfig());
        mBitmap.setPixels(outPixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    public static Bitmap resizeBitmap(Bitmap bitmap, int dstWidth, int dstHeight, boolean stretchBitmap) {
        if (bitmap == null) {
            return null;
        }
        if (bitmap.getWidth() == dstWidth && bitmap.getHeight() == dstHeight) {
            return bitmap;
        }
        if (dstWidth < 1 || dstHeight < 1) {
            throw new IllegalArgumentException("Bitmap output width and height must greater than 1");
        }
        if (stretchBitmap) {
            float scaleX = (float)dstWidth / (float)bitmap.getWidth();
            float scaleY = (float)dstHeight / (float)bitmap.getHeight();
            Matrix matrix = new Matrix();
            matrix.postScale(scaleX, scaleY);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        } else {
            Bitmap paddingBitmap = Bitmap.createBitmap((int)dstWidth, (int)dstHeight, (Bitmap.Config)bitmap.getConfig());
            Canvas canvas = new Canvas(paddingBitmap);
            canvas.drawColor(-1);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
            bitmap = paddingBitmap;
        }
        return bitmap;
    }

    public static byte[] getDotMatrixOfBitmapForPrint(Bitmap bitmap, boolean shake) {
        return BitmapUtils.getDotMatrixOfBitmapForPrint(bitmap, shake, true);
    }

    public static byte[] getDotMatrixOfBitmapForPrint(Bitmap bitmap, boolean shake, boolean reverseBit) {
        int columnSize = (int)Math.ceil((double)bitmap.getWidth() / 8.0);
        byte[] data = new byte[columnSize * bitmap.getHeight()];
        int dataIndex = 0;
        int height = bitmap.getHeight();
        int width = bitmap.getWidth();
        int[] pixels = BitmapUtils.thresholdBitmapPixels(bitmap, shake);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < columnSize; ++x) {
                for (int dataBit = 0; dataBit < 8; ++dataBit) {
                    int lineIndex = x * 8 + dataBit;
                    if (lineIndex >= width) continue;
                    int pixelColor = pixels[y * width + lineIndex];
                    int R = pixelColor >> 16 & 0xFF;
                    int G = pixelColor >> 8 & 0xFF;
                    int B = pixelColor & 0xFF;
                    int GR = (int)((float)R * 0.3f + (float)G * 0.59f + (float)B * 0.11f);
                    if (GR < 128) {
                        if (reverseBit) {
                            data[dataIndex] = (byte)(data[dataIndex] << 1 | 1);
                            continue;
                        }
                        data[dataIndex] = (byte)(data[dataIndex] << 1 & 0xFE);
                        continue;
                    }
                    data[dataIndex] = reverseBit ? (byte)(data[dataIndex] << 1 & 0xFE) : (byte)(data[dataIndex] << 1 | 1);
                }
                ++dataIndex;
            }
        }
        return data;
    }

    public static byte[] getDotMatrixOfBitmapForPrintVertical(Bitmap bitmap, boolean shake) {
        byte[] data = new byte[bitmap.getHeight() * bitmap.getWidth() / 8];
        int dataIndex = 0;
        int dataBit = 0;
        int height = bitmap.getHeight();
        int width = bitmap.getWidth();
        int[] pixels = BitmapUtils.thresholdBitmapPixels(bitmap, shake);
        for (int x = 0; x < width; ++x) {
            int y = 0;
            while (y < height) {
                dataBit = (pixels[width * y + x] & 0xFF) > 127 ? dataBit << 1 & 0xFE : dataBit << 1 | 1;
                if (++y % 8 != 0) continue;
                data[dataIndex++] = (byte)dataBit;
                dataBit = 0;
            }
        }
        return data;
    }

    public static int[] thresholdBitmapPixels(Bitmap bitmap, boolean shake) {
        bitmap = BitmapUtils.convertGrayBitmapByColorFilter(bitmap);
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        if (shake) {
            int[] grays = Arrays.copyOf(pixels, pixels.length);
            for (int i = 0; i < grays.length; ++i) {
                grays[i] = grays[i] >> 16 & 0xFF;
            }
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int e;
                    int px = grays[width * i + j] & 0xFF;
                    if (px >= 128) {
                        pixels[width * i + j] = -1;
                        e = px - 255;
                    } else {
                        pixels[width * i + j] = -16777216;
                        e = px - 0;
                    }
                    if (j < width - 1 && i < height - 1) {
                        int n = width * i + j + 1;
                        grays[n] = grays[n] + 7 * e / 16;
                        int n2 = width * (i + 1) + j;
                        grays[n2] = grays[n2] + 5 * e / 16;
                        int n3 = width * (i + 1) + j + 1;
                        grays[n3] = grays[n3] + e / 16;
                        if (j <= 0) continue;
                        int n4 = width * (i + 1) + j - 1;
                        grays[n4] = grays[n4] + 3 * e / 16;
                        continue;
                    }
                    if (j == width - 1 && i < height - 1) {
                        int n = width * (i + 1) + j;
                        grays[n] = grays[n] + 5 * e / 16;
                        continue;
                    }
                    if (j >= width - 1 || i != height - 1) continue;
                    int n = width * i + j + 1;
                    grays[n] = grays[n] + 7 * e / 16;
                }
            }
        } else {
            for (int i = 0; i < pixels.length; ++i) {
                int r = pixels[i] >> 16 & 0xFF;
                int g = pixels[i] >> 8 & 0xFF;
                int b = pixels[i] & 0xFF;
                int gr = (int)((float)r * 0.3f + (float)g * 0.59f + (float)b * 0.11f);
                pixels[i] = gr >= 128 ? -1 : -16777216;
            }
        }
        return pixels;
    }

    public static Bitmap convertGrayBitmapByColorFilter(Bitmap bitmap) {
        int height = bitmap.getHeight();
        int width = bitmap.getWidth();
        Bitmap grayBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(grayBitmap);
        c.drawColor(-1);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return grayBitmap;
    }
}

